; // final detail depends on scale (m) and number of iterations
; // should be yRes^(1/iters), or (yRes / 1.5)^(1/iters) for diagonal lines
;
; // speed depends on number of iterations: .1*iTime is nice for 32 iters
;
; void mainImage( out vec4 o, vec2 u ) {
;   float t = .1*iTime;
;   vec3 m = 1.14 * vec3(cos(t), sin(t), -sin(t));
;   vec2 p = 1. + vec2(sin(t*1.618), sin(t*log(10.)));
;   vec2 q = vec2(0); //p //.2 * vec2(sin(t*.1*log(7.)), sin(t*.1*sqrt(2.)));
;   o.xyz = iResolution;
; //  u = (u+u-o.xy)/o.y + p;
;   u = (u+u-o.xy)/o.y;
;   u = floor(100. * u) / 100.;
;   // 100^(1/16) = 1.333
;   // 100^(1/24) = 1.211
;   // 100^(1/32) = 1.154
;   for(int i=0; i<32; i++) {
;       u = (abs(u) - p) * mat2(m.xzyx);
;   }
;   u = clamp(abs(u),0.,2.);
; //  u = floor(8. * u) / 8.;
;   o = sqrt(vec4(u.y, .5 * (u.x+u.y), u.x, 0)) - .25;
; //  o = vec4(u.y, .5 * (u.x+u.y), u.x, 0);
; }


;vec2 sq(vec2 x) { return x*x; }
;
;void mainImage( out vec4 o, vec2 u ) {
;  float t = .05*iTime;
;  float T = t*3.141592653589;
;  vec3 m = 1.14 * vec3(cos(T), sin(T), -sin(T));
;  vec2 p = sq(vec2(sin(t), sin(t*1.4426950408)));
;  o.xyz = iResolution;
;//  u = (u+u-o.xy)/o.y + p;
;  u = (u+u-o.xy)/o.x;
;  u = floor(100. * u) / 100.;
;  // 100^(1/16) = 1.333
;  // 100^(1/24) = 1.211
;  // 100^(1/32) = 1.154
;  for(int i=0; i<32; i++) {
;      u = (abs(u) - p) * mat2(m.xzyx);
;  }
;  u = clamp(abs(u) * 4.,0.,2.);
;//  u = floor(8. * u) / 8.;
;  o = sqrt(vec4(u.y, .5 * (u.x+u.y), u.x, 0)) - .25;
;//  o = vec4(u.y, .5 * (u.x+u.y), u.x, 0);
;}



org 100h  ; assume al=0 bx=0 si=0x100

  add al,0x13  ;04 13
  cwd          ; dx=0
P add ch,cl
;  shr ch,1     ; ch=G=(R+B)/2 cl=B
  shr cx,1     ; ch=G=(R+B)/2 cl=B/2
  mov bp,dx    ; bp=4 after loop

  int 0x10
  dec bx       ; index++: 255..1 (0 stays black)
  dec dx
  mov ax,0x1010; set palette: bl=index dh=R=0 ch=G cl=B=0xff
U equ $-1 ; U=-32438
TIMESTEP: ;(float32)0.0115
  and dx,0x3c3c; dx= ..RRRR.. ..BBBB..
V equ $-1 ; V=-30404
  mov cx,dx    ; ch=R cl=B
  jnz P
               ; cx=dx=0 bx=0xff00 bp=4

ZOOM equ $-2  ; 1.13
  nop
  aas

  mov bh,0xa0
  mov es,bx

  fldz             ; t=t0
M fsub dword[byte bp-4+si-0x100+TIMESTEP]  ; t-=dt

  fld st0
  fsincos          ; c=cos(t) s=sin(t) t
  fdiv st1,st0     ; c s/c t
  fmul dword[byte bp-4+si-0x100+ZOOM]; c*=zoom s/c t

  fldln2
  fmul st3
  fsin             ; sin(t*ln2) c s/c t
  fmul st0         ; sin(t*ln2)^2
  fimul word[byte bp-4+si-0x100+U] ; u=-32438*sin(t*ln2)^2 c*zoom s/c t

N mov ax,0xcccd
  mul di
  add dx,bx  ; +a000
  push dx
  push ax    ; [-4]=y, [-5]=x

  fild word[bp-4-4] ; y c s/c t
  fild word[bp-4-5] ; x y c s/c t

  mov cl,32
L fabs
  fadd st2          ; x=|x|+u y u c s/c t  ; y=|y|+v sx u c s/c t
  fmul st3          ; cx y u c s/c t       ; cy sx u c s/c t
  fst dword[si]     ; [0x100]=cx           ; [0x104]=cy
  fmul st4          ; sx y u c s/c t       ; sy sx u c s/c t
  fxch st1          ; y sx u c s/c t       ; sx sy u c s/c t
  xor si,bp  ; cf=0
  jpo L
  fadd dword[si+bp] ; y=cy+sx sy u c s/c t
  fxch st1
  fsubr dword[si]   ; x=cx-sy y u c s/c t
  loop L

  mov cl,2
S fabs
  fistp word[bp+si] ; store |2x|   ; store |2y|
  imul ax,[bp+si],2
  sbb ah,ch         ; ah-=0: ah=0xff on overflow
  shld word[es:di],ax,4
  pop dx     ; pop twice
  loop S

  inc di
  jnz N

  fcompp
  fstp st0          ; t

;esc?
  in al,0x60
  cmp al,1
  jne M
  ret
